/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.editor.php.indexer.IReportable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IncludePHPEntryValue
implements IReportable {
    public static int INCLUDE_TYPE = 0;
    public static int INCLUDE_ONCE_TYPE = 1;
    public static int REQUIRE_TYPE = 2;
    public static int REQUIRE_ONCE_TYPE = 3;
    private final String includePath;
    private final int startOffset;
    private final int endOffset;
    private final int pathStartOffset;
    private final int type;

    public IncludePHPEntryValue(String includePath, int startOffset, int endOffset, int pathStartOffset, int type) {
        this.includePath = includePath;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.pathStartOffset = pathStartOffset;
        this.type = type;
    }

    public IncludePHPEntryValue(DataInputStream di) throws IOException {
        this.includePath = di.readUTF();
        this.startOffset = di.readInt();
        this.endOffset = di.readInt();
        this.pathStartOffset = di.readInt();
        this.type = di.readInt();
    }

    @Override
    public void store(DataOutputStream da) throws IOException {
        da.writeInt(this.getKind());
        da.writeUTF(this.includePath);
        da.writeInt(this.startOffset);
        da.writeInt(this.endOffset);
        da.writeInt(this.pathStartOffset);
        da.writeInt(this.type);
    }

    public String getIncludePath() {
        return this.includePath;
    }

    public String toString() {
        return "Include: " + this.includePath;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getPathStartOffset() {
        return this.pathStartOffset;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public int getKind() {
        return 5;
    }
}

